import rateLimit from 'express-rate-limit';

// Create a limiter: 10 requests per .5 minute
const apiLimiter = rateLimit({
    windowMs: 1 * 30 * 1000, // 30 sec
    max: 10, // limit each IP to 60 requests per windowMs
    message: 'Too many requests from this IP, please try again after a minute',
});

export default apiLimiter;
