import { Request, Response } from 'express';
import prisma from '../prisma/client';

export const getAllCourse = async (req: Request, res: Response) => {
    try {
        const course = await prisma.course.findMany();
        res.json(course);
    } catch (error) {
        console.error('Error fetching categories:', error);
        res.status(500).json({ error: 'Failed to fetch categories' });
    }
};
