// console.log("Server starting...");

// const express = require("express");
// const cors = require("cors");
// const helmet = require("helmet");
// const pool = require("./config/db");
// require("dotenv").config();

// const PORT = process.env.PORT || 5000;
// const app = express();

// // Middleware
// app.use(express.json());
// app.use(express.urlencoded({ extended: true }));
// app.use(cors());
// app.use(helmet());

// // Logging middleware
// // app.use((req, res, next) => {
// //     console.log(`${req.method} ${req.url} - ${new Date().toISOString()}`);
// //     next();
// // });

// // Database connection verification
// let dbConnected = false;
// const verifyDbConnection = async () => {
//     try {
//         const client = await pool.connect();
//         dbConnected = true;
//         console.log("✅ Database connection successful");
//         client.release();
//     } catch (err) {
//         dbConnected = false;
//         console.error("❌ Database connection failed:", err.message);
//         // Retry connection after 5 seconds
//         // setTimeout(verifyDbConnection, 5000);
//     }
// };

// // Call verification on startup
// verifyDbConnection();

// // Default Route
// app.get("/", (req, res) => {
//     res.json({
//         message: "Welcome to the Kurilo API manish ",
//         status: "running",
//         dbStatus: dbConnected ? "connected" : "disconnected"
//     });
// });

// // Health check endpoint
// app.get("/health", (req, res) => {
//     res.json({
//         status: "ok",
//         timestamp: new Date().toISOString(),
//         dbStatus: dbConnected ? "connected" : "disconnected"
//     });
// });

// app.get("/category", async (req, res) => {
//     try {
//         if (!dbConnected) {
//             return res.status(503).json({
//                 error: "Database connection unavailable",
//                 message: "The server is currently unable to connect to the database"
//             });
//         }

//         const result = await pool.query("SELECT * FROM kl_category_tbl");
//         res.json({
//             success: true,
//             count: result.rows.length,
//             data: result.rows
//         });
//     } catch (err) {
//         console.error("Error fetching categories:", err.message);
//         res.status(500).json({
//             error: "Server Error",
//             message: err.message
//         });
//     }
// });

// // Import routes
// app.use("/api/category/all", require("./routers/IqCategoryRoute"));

// // 404 handler
// app.use((req, res) => {
//     res.status(404).json({
//         error: "Not Found",
//         message: `Route ${req.originalUrl} not found`
//     });
// });

// // Error handler
// app.use((err, req, res, next) => {
//     console.error("Unhandled error:", err);
//     res.status(500).json({
//         error: "Server Error",
//         message: process.env.NODE_ENV === 'production' ? 'An unexpected error occurred' : err.message
//     });
// });

// // Start Server
// app.listen(PORT, () => {
//     console.log(`🚀 Server running at port ${PORT}`);
//     console.log(`🌐 API available at http://localhost:${PORT}`);
// });

// // Handle graceful shutdown
// process.on('SIGTERM', () => {
//     console.log('SIGTERM received, shutting down gracefully');
//     pool.end().then(() => {
//         console.log('Database pool closed');
//         process.exit(0);
//     });
// });